/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.server;

import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMClient;

public class RxClientUtils {
    private RxClientUtils() {
    }

    private static void updateProperties(RObject rObject, Vector vector) throws CIMException {
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            String string = cIMProperty.getName();
            CIMDataType cIMDataType = cIMProperty.getType();
            Object object = null;
            try {
                object = rObject.getProperty(string);
            }
            catch (RException rException) {
                throw new CIMException(rException.getID());
            }
            CIMValue cIMValue = null;
            if (object != null) {
                cIMValue = new CIMValue(object, cIMDataType);
            }
            cIMProperty.setValue(cIMValue);
            ++n;
        }
    }

    public static CIMInstance getCIMInstance(CIMClient cIMClient, RObject rObject) throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            RClassSchema rClassSchema = rObject.getSchema();
            int n = rObject.getNameSpaceId();
            String string = RUtils.getNameSpaceString(n);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(rClassSchema.getClassName(), string);
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false);
            cIMInstance = cIMClass.newInstance();
            Vector vector = cIMInstance.getProperties();
            RxClientUtils.updateProperties(rObject, vector);
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new CIMException(rException.getID());
        }
        return cIMInstance;
    }

    public static CIMObjectPath getCIMObjectPath(RObjectId rObjectId) throws CIMException {
        try {
            String string = RUtils.getNameSpaceString(rObjectId.getNameSpaceId());
            RClassSchema rClassSchema = RUtils.getClassSchema(rObjectId.getNameSpaceId(), rObjectId.getClassId());
            CIMObjectPath cIMObjectPath = new CIMObjectPath(rClassSchema.getClassName(), string);
            int n = rObjectId.getNumOfKeys();
            int n2 = 0;
            while (n2 < n) {
                int n3 = rClassSchema.getKeyPos(n2);
                String string2 = rClassSchema.getPropName(n3);
                cIMObjectPath.addKey(string2, new CIMValue(rObjectId.getKeyValue(n2)));
                ++n2;
            }
            return cIMObjectPath;
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new CIMException(rException.getID());
        }
    }
}

